/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;
import wjhk.jupload2.upload.helper.HTTPInputStreamReader;
import wjhk.jupload2.upload.helper.InteractiveTrustManager;

public class HttpConnect {
    private static final String HTTPCONNECT_DEFAULT_PROTOCOL = "HTTP/1.1";
    private UploadPolicy uploadPolicy;

    private Socket HttpProxyConnect(Proxy proxy, String host, int port) throws UnknownHostException, IOException, ConnectException {
        InetSocketAddress sa = (InetSocketAddress)proxy.address();
        String phost = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
        int pport = sa.getPort();
        Socket proxysock = new Socket(phost, pport);
        String req = "CONNECT " + host + ":" + port + " " + HTTPCONNECT_DEFAULT_PROTOCOL + "\r\n\r\n";
        proxysock.getOutputStream().write(req.getBytes());
        BufferedReader proxyIn = new BufferedReader(new InputStreamReader(proxysock.getInputStream()));
        String line = proxyIn.readLine();
        if (!line.matches("^HTTP/\\d\\.\\d\\s200\\s.*")) {
            throw new ConnectException("Proxy response: " + line);
        }
        this.uploadPolicy.displayDebug("Proxy response: " + line, 80);
        proxyIn.readLine();
        return proxysock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket Connect(URL url, Proxy proxy) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        int port;
        boolean useProxy;
        Socket ret = null;
        String host = url.getHost();
        boolean bl = useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        if (url.getProtocol().equals("https")) {
            int port2 = -1 == url.getPort() ? 443 : url.getPort();
            SSLContext context = SSLContext.getInstance("SSL");
            InteractiveTrustManager tm = new InteractiveTrustManager(this.uploadPolicy, url.getHost(), null);
            context.init(tm.getKeyManagers(), tm.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
            if (useProxy) {
                if (proxy.type() == Proxy.Type.HTTP) {
                    this.uploadPolicy.displayDebug("Using SSL socket, via HTTP proxy", 20);
                    return context.getSocketFactory().createSocket(this.HttpProxyConnect(proxy, host, port2), host, port2, true);
                }
                if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
                this.uploadPolicy.displayDebug("Using SSL socket, via SOCKS proxy", 20);
                Socket tsock = new Socket(proxy);
                tsock.connect(new InetSocketAddress(host, port2));
                return context.getSocketFactory().createSocket(tsock, host, port2, true);
            }
            this.uploadPolicy.displayDebug("Using SSL socket, direct connection", 20);
            return context.getSocketFactory().createSocket(host, port2);
        }
        int n = port = -1 == url.getPort() ? 80 : url.getPort();
        if (useProxy) {
            if (proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress sa = (InetSocketAddress)proxy.address();
                host = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
                port = sa.getPort();
                this.uploadPolicy.displayDebug("Using non SSL socket, proxy=" + host + ":" + port, 20);
                return new Socket(host, port);
            }
            if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
            this.uploadPolicy.displayDebug("Using non SSL socket, via SOCKS proxy", 20);
            Socket tsock = new Socket(proxy);
            tsock.connect(new InetSocketAddress(host, port));
            return tsock;
        }
        this.uploadPolicy.displayDebug("Using non SSL socket, direct connection", 20);
        return new Socket(host, port);
    }

    public Socket Connect(URL url) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, URISyntaxException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        return this.Connect(url, proxy);
    }

    public String getProtocol() throws URISyntaxException, KeyManagementException, NoSuchAlgorithmException, UnknownHostException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException, IOException, JUploadException {
        Pattern pLocation;
        Matcher mLocation;
        String protocol = HTTPCONNECT_DEFAULT_PROTOCOL;
        URL url = new URL(this.uploadPolicy.getPostURL());
        this.uploadPolicy.displayDebug("Checking protocol with URL: " + url, 30);
        HTTPConnectionHelper connectionHelper = new HTTPConnectionHelper(url, "HEAD", false, true, this.uploadPolicy);
        connectionHelper.append("\r\n");
        this.uploadPolicy.displayDebug("Before sendRequest()", 30);
        connectionHelper.sendRequest();
        this.uploadPolicy.displayDebug("After sendRequest()", 30);
        connectionHelper.getOutputStream().flush();
        if (this.uploadPolicy.getDebugLevel() >= 80) {
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug("-----------------   HEAD message sent (start)  --------------------------", 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug(connectionHelper.getByteArrayEncoder().getString(), 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug("-----------------   HEAD message sent (end) -----------------------------", 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
        }
        int status = connectionHelper.readHttpResponse();
        this.uploadPolicy.displayDebug("HEAD status: " + status, 30);
        String headers = connectionHelper.getResponseHeaders();
        Matcher m = Pattern.compile("^(HTTP/\\d\\.\\d)\\s(.*)\\s.*$", 8).matcher(headers);
        if (!m.find()) {
            this.uploadPolicy.displayErr("Unexpected HEAD response (can't find the protocol): will use the default one.");
        } else {
            protocol = m.group(1);
            this.uploadPolicy.displayDebug("HEAD protocol: " + protocol, 30);
        }
        Pattern pIIS = Pattern.compile("^Server: .*IIS*$", 8);
        Matcher mIIS = pIIS.matcher(headers);
        if (mIIS.find()) {
            try {
                this.uploadPolicy.setProperty("allowHttpPersistent", "false");
                this.uploadPolicy.displayWarn("allowHttpPersistent' forced to false, for IIS compatibility (in HttpConnect.getProtocol())");
            }
            catch (JUploadException e) {
                this.uploadPolicy.displayWarn("Can't set property 'allowHttpPersistent' to false, in HttpConnect.getProtocol()");
            }
        }
        if ((status == 301 || status == 302 || status == 303) && (mLocation = (pLocation = Pattern.compile("^Location: (.*)$", 8)).matcher(headers)).find()) {
            this.uploadPolicy.displayDebug("Location read: " + mLocation.group(1), 50);
            this.changePostURL(mLocation.group(1));
        }
        return protocol;
    }

    public String getProtocolOld() throws URISyntaxException, KeyManagementException, NoSuchAlgorithmException, UnknownHostException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException, IOException, JUploadException {
        String protocol = HTTPCONNECT_DEFAULT_PROTOCOL;
        String returnCode = null;
        boolean bRedirect = false;
        URL url = new URL(this.uploadPolicy.getPostURL());
        this.uploadPolicy.displayDebug("Checking protocol with URL: " + url, 30);
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        boolean useSSL = url.getProtocol().equals("https");
        Socket s = this.Connect(url, proxy);
        PushbackInputStream in = new PushbackInputStream(s.getInputStream());
        StringBuffer req = new StringBuffer();
        req.append("HEAD ");
        if (useProxy && !useSSL) {
            req.append(url.getProtocol()).append("://").append(url.getHost());
        }
        req.append(url.getPath());
        if (null != url.getQuery() && !"".equals(url.getQuery())) {
            req.append("?").append(url.getQuery());
        }
        req.append(" ").append(HTTPCONNECT_DEFAULT_PROTOCOL).append("\r\n");
        req.append("Host: ").append(url.getHost()).append("\r\n");
        req.append("Connection: close\r\n\r\n");
        OutputStream os = s.getOutputStream();
        os.write(req.toString().getBytes());
        os.flush();
        String firstLine = HTTPInputStreamReader.readLine(in, "US-ASCII", false);
        if (null == firstLine) {
            this.uploadPolicy.displayWarn("EMPTY HEAD response");
        } else {
            Matcher m = Pattern.compile("^(HTTP/\\d\\.\\d)\\s(.*)\\s.*").matcher(firstLine);
            if (!m.matches()) {
                this.uploadPolicy.displayErr("Unexpected HEAD response: '" + firstLine + "'");
            }
            this.uploadPolicy.displayDebug("HEAD response: " + firstLine, 80);
            protocol = m.group(1);
            returnCode = m.group(2);
            if (returnCode.equals("301") || returnCode.equals("302") || returnCode.equals("303")) {
                bRedirect = true;
                this.uploadPolicy.displayInfo("Received " + returnCode + " (current postURL: " + this.uploadPolicy.getPostURL() + ")");
            }
        }
        String nextLine = HTTPInputStreamReader.readLine(in, "US-ASCII", false);
        Pattern pLocation = Pattern.compile("^Location: (.*)$");
        while ((nextLine = HTTPInputStreamReader.readLine(in, "US-ASCII", false)).length() > 0) {
            Matcher mLocation;
            if (nextLine.matches("^Server: .*IIS")) {
                try {
                    this.uploadPolicy.setProperty("allowHttpPersistent", "false");
                    this.uploadPolicy.displayWarn("allowHttpPersistent' forced to false, for IIS compatibility (in HttpConnect.getProtocol())");
                }
                catch (JUploadException e) {
                    this.uploadPolicy.displayWarn("Can't set property 'allowHttpPersistent' to false, in HttpConnect.getProtocol()");
                }
                break;
            }
            if (!bRedirect || !(mLocation = pLocation.matcher(nextLine)).matches()) continue;
            this.uploadPolicy.displayDebug("Location read: " + mLocation.group(1), 50);
            this.changePostURL(mLocation.group(1));
        }
        if (!(s instanceof SSLSocket)) {
            s.shutdownOutput();
        }
        s.close();
        return protocol;
    }

    private void changePostURL(String newLocation) throws JUploadException {
        String currentPostURL = this.uploadPolicy.getPostURL();
        Pattern pHostName = Pattern.compile("http://([^/]*)/.*");
        Matcher mOldPostURL = Pattern.compile("(.*)\\?(.*)").matcher(currentPostURL);
        String newPostURL = mOldPostURL.matches() ? newLocation + '?' + mOldPostURL.group(2) : newLocation;
        Matcher mHostOldPostURL = pHostName.matcher(currentPostURL);
        if (!mHostOldPostURL.matches()) {
            throw new JUploadException("[HttpConnect.changePostURL()] No host found in the old postURL !");
        }
        Matcher mHostNewLocation = pHostName.matcher(newLocation);
        if (!mHostNewLocation.matches()) {
            if (newLocation.startsWith("/")) {
                newPostURL = "http://" + mHostOldPostURL.group(1) + newPostURL;
            } else {
                Matcher mOldPostURLAllButFilename = Pattern.compile("(.*)/([^/]*)$").matcher(currentPostURL);
                if (!mOldPostURLAllButFilename.matches()) {
                    throw new JUploadException("[HttpConnect.changePostURL()] Can't find the filename in the URL !");
                }
                newPostURL = mOldPostURLAllButFilename.group(1) + "/" + newPostURL;
            }
        }
        this.uploadPolicy.setPostURL(newPostURL);
        this.uploadPolicy.displayInfo("postURL switched from " + currentPostURL + " to " + newPostURL);
    }

    public HttpConnect(UploadPolicy policy) {
        this.uploadPolicy = policy;
    }
}

