/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.DefaultFileUploadThread;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;
import wjhk.jupload2.upload.helper.ByteArrayEncoderHTTP;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;

public class FileUploadThreadHTTP
extends DefaultFileUploadThread {
    private HTTPConnectionHelper connectionHelper = null;
    private ByteArrayEncoder[] heads = null;
    private ByteArrayEncoder[] tails = null;

    public FileUploadThreadHTTP(UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) {
        super(uploadPolicy, fileUploadManagerThread);
        this.uploadPolicy.displayDebug("  Using " + this.getClass().getName(), 30);
        uploadPolicy.displayDebug("Upload done by using the " + this.getClass().getName() + " class", 30);
        this.setName("FileUploadThreadHTTP");
        this.connectionHelper = new HTTPConnectionHelper(uploadPolicy);
    }

    void beforeRequest() throws JUploadException {
        this.setAllHead(this.connectionHelper.getBoundary());
        this.setAllTail(this.connectionHelper.getBoundary());
    }

    long getAdditionnalBytesForUpload(int index) throws JUploadIOException {
        return this.heads[index].getEncodedLength() + this.tails[index].getEncodedLength();
    }

    void afterFile(int index) throws JUploadIOException {
        this.connectionHelper.append(this.tails[index].getEncodedByteArray());
        this.uploadPolicy.displayDebug("--- filetail start (len=" + this.tails[index].getEncodedLength() + "):", 70);
        this.uploadPolicy.displayDebug(this.quoteCRLF(this.tails[index].getString()), 70);
        this.uploadPolicy.displayDebug("--- filetail end", 70);
    }

    void beforeFile(int index) throws JUploadException {
        try {
            this.connectionHelper.append(this.heads[index].getEncodedByteArray());
            this.uploadPolicy.displayDebug("--- fileheader start (len=" + this.heads[index].getEncodedLength() + "):", 70);
            this.uploadPolicy.displayDebug(this.quoteCRLF(this.heads[index].getString()), 70);
            this.uploadPolicy.displayDebug("--- fileheader end", 70);
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
    }

    void cleanAll() throws JUploadException {
    }

    void cleanRequest() throws JUploadException {
        try {
            this.connectionHelper.dispose();
        }
        catch (JUploadIOException e) {
            this.uploadPolicy.displayErr(this.uploadPolicy.getString("errDuringUpload"), e);
            throw e;
        }
    }

    int finishRequest() throws JUploadException {
        if (this.uploadPolicy.getDebugLevel() > 100) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int status = this.connectionHelper.readHttpResponse();
        this.setResponseMsg(this.connectionHelper.getResponseMsg());
        this.setResponseBody(this.connectionHelper.getResponseBody());
        return status;
    }

    OutputStream getOutputStream() throws JUploadException {
        return this.connectionHelper.getOutputStream();
    }

    void startRequest(long contentLength, boolean bChunkEnabled, int chunkPart, boolean bLastChunk) throws JUploadException {
        try {
            String chunkHttpParam = "jupart=" + chunkPart + "&jufinal=" + (bLastChunk ? "1" : "0");
            this.uploadPolicy.displayDebug("chunkHttpParam: " + chunkHttpParam, 30);
            URL url = new URL(this.uploadPolicy.getPostURL());
            if (bChunkEnabled) {
                url = null != url.getQuery() && !"".equals(url.getQuery()) ? new URL(url.toExternalForm() + "&" + chunkHttpParam) : new URL(url.toExternalForm() + "?" + chunkHttpParam);
            }
            this.connectionHelper.initRequest(url, "POST", bChunkEnabled, bLastChunk);
            ByteArrayEncoder formParams = this.getFormParamsForPostRequest(url);
            this.connectionHelper.append("Content-Type: multipart/form-data; boundary=").append(this.connectionHelper.getBoundary().substring(2)).append("\r\n");
            this.connectionHelper.append("Content-Length: ").append(String.valueOf(contentLength += (long)formParams.getEncodedLength())).append("\r\n");
            this.connectionHelper.append("\r\n");
            this.connectionHelper.append(formParams);
            this.connectionHelper.sendRequest();
            this.uploadPolicy.displayDebug("=== main header (len=" + this.connectionHelper.getByteArrayEncoder().getEncodedLength() + "):\n" + this.quoteCRLF(this.connectionHelper.getByteArrayEncoder().getString()), 70);
            this.uploadPolicy.displayDebug("=== main header end", 70);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JUploadException(e);
        }
    }

    private final ByteArrayEncoder getFileHeader(int index, String bound, int chunkPart) throws JUploadException {
        String filenameEncoding = this.uploadPolicy.getFilenameEncoding();
        String mimetype = this.filesToUpload[index].getMimeType();
        String uploadFilename = this.filesToUpload[index].getUploadFilename(index);
        ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, bound);
        String form = this.uploadPolicy.getFormdata();
        if (null != form) {
            bae.appendFormVariables(form);
        }
        this.filesToUpload[index].appendFileProperties(bae);
        bae.append(bound).append("\r\n");
        bae.append("Content-Disposition: form-data; name=\"");
        bae.append(this.filesToUpload[index].getUploadName(index)).append("\"; filename=\"");
        if (filenameEncoding == null) {
            bae.append(uploadFilename);
        } else {
            try {
                this.uploadPolicy.displayDebug("Encoded filename: " + URLEncoder.encode(uploadFilename, filenameEncoding), 70);
                bae.append(URLEncoder.encode(uploadFilename, filenameEncoding));
            }
            catch (UnsupportedEncodingException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + ": " + e.getMessage() + " (in UploadFileData.getFileHeader)");
                bae.append(uploadFilename);
            }
        }
        bae.append("\"\r\n");
        bae.append("Content-Type: ").append(mimetype).append("\r\n");
        bae.append("\r\n");
        bae.close();
        return bae;
    }

    private final void setAllHead(String bound) throws JUploadException {
        this.heads = new ByteArrayEncoder[this.filesToUpload.length];
        for (int i = 0; i < this.filesToUpload.length; ++i) {
            this.heads[i] = this.getFileHeader(i, bound, -1);
        }
    }

    private final void setAllTail(String bound) throws JUploadException {
        this.tails = new ByteArrayEncoder[this.filesToUpload.length];
        for (int i = 0; i < this.filesToUpload.length; ++i) {
            ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, bound);
            bae.append("\r\n");
            bae.appendTextProperty("md5sum[]", this.filesToUpload[i].getMD5());
            if (i == this.filesToUpload.length - 1) {
                bae.append(bound).append("--\r\n");
            }
            bae.close();
            this.tails[i] = bae;
        }
    }

    private final ByteArrayEncoder getFormParamsForPostRequest(URL url) throws JUploadIOException {
        ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, this.connectionHelper.getBoundary());
        String query = url.getQuery();
        if (null != query) {
            String[] paramPairs;
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            for (String param : paramPairs = query.split("&")) {
                if (!param.contains("=")) continue;
                String[] oneParamArray = param.split("=");
                if (oneParamArray.length > 1) {
                    requestParameters.put(oneParamArray[0], oneParamArray[1]);
                    continue;
                }
                requestParameters.put(oneParamArray[0], "");
            }
            for (String key : requestParameters.keySet()) {
                bae.appendTextProperty(key, (String)requestParameters.get(key));
            }
        }
        bae.close();
        return bae;
    }
}

