/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import wjhk.jupload2.gui.IconWorker;
import wjhk.jupload2.policies.DefaultUploadPolicy;
import wjhk.jupload2.policies.PictureUploadPolicy;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadFileView
extends FileView
implements PropertyChangeListener,
ThreadFactory {
    ThreadGroup iconWorkerThreadGroup = new ThreadGroup("JUpload ThreadGroup");
    UploadPolicy uploadPolicy = null;
    JFileChooser fileChooser = null;
    ConcurrentHashMap<String, IconWorker> hashMap = new ConcurrentHashMap(1000, 0.5f);
    ExecutorService executorService = null;
    public ImageIcon emptyIcon = null;

    public JUploadFileView(UploadPolicy uploadPolicy, JFileChooser fileChooser) {
        this.uploadPolicy = uploadPolicy;
        this.fileChooser = fileChooser;
        this.fileChooser.addPropertyChangeListener(this);
        this.iconWorkerThreadGroup.setMaxPriority(1);
        if (this.emptyIcon == null || this.emptyIcon.getIconHeight() != uploadPolicy.getFileChooserIconSize()) {
            this.emptyIcon = new ImageIcon(new BufferedImage(uploadPolicy.getFileChooserIconSize(), uploadPolicy.getFileChooserIconSize(), 3));
        }
    }

    synchronized void execute(IconWorker iconWorker) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        iconWorker.status = 3;
        this.executorService.execute(iconWorker);
    }

    public synchronized void shutdownNow() {
        if (this.executorService != null) {
            this.stopRunningJobs();
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void stopRunningJobs() {
        Enumeration<IconWorker> e = this.hashMap.elements();
        IconWorker iw = null;
        while (e.hasMoreElements()) {
            iw = e.nextElement();
            if (iw.status != 3) continue;
            iw.status = 4;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.uploadPolicy.displayDebug("[JUploadFileView] Directory changed", 50);
            this.stopRunningJobs();
        }
    }

    public String getDescription(File f) {
        return null;
    }

    public Icon getIcon(File file) {
        if (!(this.uploadPolicy.getFileChooserIconFromFileContent() == 1 && this.uploadPolicy instanceof DefaultUploadPolicy || this.uploadPolicy.getFileChooserIconFromFileContent() == 0 && this.uploadPolicy instanceof PictureUploadPolicy)) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        IconWorker iconWorker = this.hashMap.get(file.getAbsolutePath());
        if (iconWorker == null) {
            iconWorker = new IconWorker(this.uploadPolicy, this.fileChooser, this, file);
            this.hashMap.put(file.getAbsolutePath(), iconWorker);
            this.execute(iconWorker);
            return this.emptyIcon;
        }
        return iconWorker.getIcon();
    }

    public String getName(File f) {
        return null;
    }

    public String getTypeDescription(File f) {
        return null;
    }

    public Boolean isTraversable(File f) {
        return null;
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.iconWorkerThreadGroup, runnable);
        thread.setPriority(1);
        return thread;
    }
}

