/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.gui.DebugDialog;
import wjhk.jupload2.policies.UploadPolicy;

final class JUploadDebugPopupMenu
extends JPopupMenu
implements ActionListener,
ItemListener,
PopupMenuListener {
    private static final long serialVersionUID = -5473337111643079720L;
    JCheckBoxMenuItem cbmiDebugOnOff = null;
    JCheckBoxMenuItem cbmiLogWindowOnOff = null;
    JMenuItem jMenuItemViewLastResponseBody = null;
    JMenuItem jMenuItemClearLogWindowContent = null;
    JMenuItem jMenuItemCopyLogWindowContent = null;
    private UploadPolicy uploadPolicy;

    JUploadDebugPopupMenu(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.addPopupMenuListener(this);
        this.cbmiDebugOnOff = new JCheckBoxMenuItem("Debug enabled");
        this.cbmiDebugOnOff.setState(this.uploadPolicy.getDebugLevel() == 100);
        this.add(this.cbmiDebugOnOff);
        this.cbmiDebugOnOff.addItemListener(this);
        this.cbmiLogWindowOnOff = new JCheckBoxMenuItem("Show log window");
        this.cbmiLogWindowOnOff.setState(this.uploadPolicy.getShowLogWindow().equals("true"));
        this.add(this.cbmiLogWindowOnOff);
        this.cbmiLogWindowOnOff.addItemListener(this);
        this.jMenuItemClearLogWindowContent = new JMenuItem("Clear the log window content");
        this.add(this.jMenuItemClearLogWindowContent);
        this.jMenuItemClearLogWindowContent.addActionListener(this);
        this.jMenuItemCopyLogWindowContent = new JMenuItem("Copy the log window content");
        this.add(this.jMenuItemCopyLogWindowContent);
        this.jMenuItemCopyLogWindowContent.addActionListener(this);
        this.jMenuItemViewLastResponseBody = new JMenuItem("View last response body");
        this.add(this.jMenuItemViewLastResponseBody);
        this.jMenuItemViewLastResponseBody.addActionListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.cbmiDebugOnOff == e.getItem()) {
            this.uploadPolicy.setDebugLevel(this.cbmiDebugOnOff.isSelected() ? 100 : 0);
        } else if (this.cbmiLogWindowOnOff == e.getItem()) {
            if (this.cbmiLogWindowOnOff.isSelected()) {
                this.uploadPolicy.setShowLogWindow("true");
            } else {
                this.uploadPolicy.setShowLogWindow("false");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.jMenuItemViewLastResponseBody == e.getSource()) {
            try {
                new DebugDialog(null, this.uploadPolicy.getLastResponseBody(), this.uploadPolicy);
            }
            catch (JUploadIOException e1) {
                this.uploadPolicy.displayErr(e1);
            }
        } else if (this.jMenuItemClearLogWindowContent == e.getSource()) {
            this.uploadPolicy.getApplet().getUploadPanel().clearLogWindow();
        } else if (this.jMenuItemCopyLogWindowContent == e.getSource()) {
            this.uploadPolicy.getApplet().getUploadPanel().copyLogWindow();
        }
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        String s = this.uploadPolicy.getLastResponseBody();
        this.jMenuItemViewLastResponseBody.setEnabled(s != null && !s.equals(""));
    }
}

