/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;

public class DebugDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7802205907550854333L;
    JButton buttonClose;
    File lastReponseBodyFile = null;
    UploadPolicy uploadPolicy = null;

    public DebugDialog(Frame owner, String text, UploadPolicy uploadPolicy) throws JUploadIOException {
        this.uploadPolicy = uploadPolicy;
        this.buttonClose = new JButton(uploadPolicy.getString("buttonClose"));
        this.buttonClose.setMaximumSize(new Dimension(100, 100));
        this.buttonClose.addActionListener(this);
        JEditorPane editorPane = new JEditorPane();
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(250, 145));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        this.setText(editorPane, text);
        this.getContentPane().add((Component)this.buttonClose, "South");
        this.getContentPane().add(editorScrollPane);
        try {
            this.pack();
        }
        catch (IllegalArgumentException e) {
            uploadPolicy.displayWarn("IllegalArgumentException while packing the DebugWindow (bad HTML ?)");
            uploadPolicy.displayErr(e);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(0, 0, screenSize.width, screenSize.height);
        this.setTitle("JUpload DebugDialog: last response body");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand() == this.buttonClose.getActionCommand()) {
            this.uploadPolicy.displayDebug("[DebugDialog] Before this.dispose()", 50);
            this.dispose();
        }
    }

    public void setText(JEditorPane editorPane, String text) throws JUploadIOException {
        this.uploadPolicy.getApplet().registerUnload(this, "deleteLog");
        try {
            this.lastReponseBodyFile = File.createTempFile("jupload_", "_LRB.html");
            FileOutputStream fos = new FileOutputStream(this.lastReponseBodyFile);
            fos.write(text.getBytes());
            fos.close();
            URL lastResponseBodyLocalPage = this.lastReponseBodyFile.toURI().toURL();
            editorPane.setEditable(false);
            editorPane.setPage(lastResponseBodyLocalPage);
            HTMLEditorKit ek = (HTMLEditorKit)editorPane.getEditorKit();
            Document doc = ek.createDefaultDocument();
            doc.putProperty("Base", "http://localhost/coppermine/");
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
    }

    public void deleteLog() {
        try {
            if (null != this.lastReponseBodyFile) {
                this.lastReponseBodyFile.delete();
                this.lastReponseBodyFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        super.dispose();
        this.deleteLog();
    }
}

