/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

class NimRODUtils {
    protected static Color rollColor;
    static final int THIN = 0;
    static final int FAT = 1;
    static final int MATRIX_FAT = 5;
    static Kernel kernelFat;
    static final int MATRIX_THIN = 3;
    static Kernel kernelThin;

    NimRODUtils() {
    }

    static Color getSombra() {
        return NimRODUtils.getColorAlfa(NimRODUtils.getColorTercio(NimRODLookAndFeel.getControlDarkShadow(), Color.black), 64);
    }

    static Color getBrillo() {
        return NimRODUtils.getColorAlfa(NimRODUtils.getColorTercio(NimRODLookAndFeel.getControlHighlight(), Color.white), 64);
    }

    static Color getSombraMenu() {
        return new Color(20, 20, 20, 50);
    }

    static Color getBrilloMenu() {
        return new Color(255, 255, 255, 64);
    }

    static NimRODTheme iniCustomColors(NimRODTheme nimRODTheme, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        if (string != null) {
            nimRODTheme.setPrimary(Color.decode(string));
        }
        if (string2 != null) {
            nimRODTheme.setSecondary(Color.decode(string2));
        }
        if (string3 != null) {
            nimRODTheme.setPrimary1(Color.decode(string3));
        }
        if (string4 != null) {
            nimRODTheme.setPrimary2(Color.decode(string4));
        }
        if (string5 != null) {
            nimRODTheme.setPrimary3(Color.decode(string5));
        }
        if (string6 != null) {
            nimRODTheme.setSecondary1(Color.decode(string6));
        }
        if (string7 != null) {
            nimRODTheme.setSecondary2(Color.decode(string7));
        }
        if (string8 != null) {
            nimRODTheme.setSecondary3(Color.decode(string8));
        }
        if (string9 != null) {
            nimRODTheme.setWhite(Color.decode(string9));
        }
        if (string10 != null) {
            nimRODTheme.setBlack(Color.decode(string10));
        }
        if (string11 != null) {
            nimRODTheme.setMenuOpacity(Integer.parseInt(string11));
        }
        if (string12 != null) {
            nimRODTheme.setFrameOpacity(Integer.parseInt(string12));
        }
        return nimRODTheme;
    }

    static ImageIcon loadRes(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(NimRODUtils.readStream(NimRODLookAndFeel.class.getResourceAsStream(string))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("No se puede cargar el recurso " + string);
            return null;
        }
    }

    static byte[] readStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray, 0, 256)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static void pintaBarraMenu(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            graphics.setColor(jMenuItem.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        if (jMenuItem instanceof JMenu && !((JMenu)jMenuItem).isTopLevelMenu() && buttonModel.isSelected() || buttonModel.isArmed()) {
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
            float_.x = 1.0f;
            float_.y = 0.0f;
            float_.width = n - 3;
            float_.height = n2 - 1;
            float_.arcwidth = 8.0f;
            float_.archeight = 8.0f;
            GradientPaint gradientPaint = new GradientPaint(1.0f, 1.0f, NimRODUtils.getBrilloMenu(), 0.0f, n2, NimRODUtils.getSombraMenu());
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(color);
            graphics2D.fill(float_);
            graphics.setColor(color.darker());
            graphics2D.draw(float_);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(float_);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        graphics.setColor(color2);
    }

    static void paintFocus(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        NimRODUtils.paintFocus(graphics, n, n2, n3, n4, n5, n6, 2.0f, color);
    }

    static void paintFocus(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, float f, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(f));
        if (n5 == 0 && n6 == 0) {
            graphics.drawRect(n, n2, n3, n4);
        } else {
            graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    static Color getRolloverColor() {
        if (rollColor == null) {
            rollColor = NimRODUtils.getColorAlfa(UIManager.getColor("Button.focus"), 40);
        }
        return rollColor;
    }

    static Color getColorAlfa(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    static Color getColorMedio(Color color, Color color2) {
        return new Color(NimRODUtils.propInt(color.getRed(), color2.getRed(), 2), NimRODUtils.propInt(color.getGreen(), color2.getGreen(), 2), NimRODUtils.propInt(color.getBlue(), color2.getBlue(), 2));
    }

    static ColorUIResource getColorTercio(Color color, Color color2) {
        return new ColorUIResource(NimRODUtils.propInt(color.getRed(), color2.getRed(), 3), NimRODUtils.propInt(color.getGreen(), color2.getGreen(), 3), NimRODUtils.propInt(color.getBlue(), color2.getBlue(), 3));
    }

    private static int propInt(int n, int n2, int n3) {
        return n2 + (n - n2) / n3;
    }

    static void paintShadowTitleFat(Graphics graphics, String string, int n, int n2, Color color) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, Color.black, 1, 1, 0);
    }

    static void paintShadowTitleFat(Graphics graphics, String string, int n, int n2, Color color, Color color2) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, 1, 1, 0);
    }

    static void paintShadowTitleFat(Graphics graphics, String string, int n, int n2, Color color, Color color2, int n3) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, n3, 1, 0);
    }

    static void paintShadowTitleThin(Graphics graphics, String string, int n, int n2, Color color) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, Color.black, 1, 0, 0);
    }

    static void paintShadowTitleThin(Graphics graphics, String string, int n, int n2, Color color, Color color2) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, 1, 0, 0);
    }

    static void paintShadowTitleThin(Graphics graphics, String string, int n, int n2, Color color, Color color2, int n3) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, n3, 0, 0);
    }

    static void paintShadowTitleFatV(Graphics graphics, String string, int n, int n2, Color color) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, Color.black, 1, 1, 1);
    }

    static void paintShadowTitleFatV(Graphics graphics, String string, int n, int n2, Color color, Color color2) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, 1, 1, 1);
    }

    static void paintShadowTitleFatV(Graphics graphics, String string, int n, int n2, Color color, Color color2, int n3) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, n3, 1, 1);
    }

    static void paintShadowTitleThinV(Graphics graphics, String string, int n, int n2, Color color) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, Color.black, 1, 0, 1);
    }

    static void paintShadowTitleThinV(Graphics graphics, String string, int n, int n2, Color color, Color color2) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, 1, 0, 1);
    }

    static void paintShadowTitleThinV(Graphics graphics, String string, int n, int n2, Color color, Color color2, int n3) {
        NimRODUtils.paintShadowTitle(graphics, string, n, n2, color, color2, n3, 0, 1);
    }

    static void paintShadowTitle(Graphics graphics, String string, int n, int n2, Color color, Color color2, int n3, int n4, int n5) {
        Font font = graphics.getFont();
        if (n5 == 1) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            font = font.deriveFont(affineTransform);
        }
        if (color2 != null) {
            int n6;
            int n7;
            int n8 = n4 == 0 ? 3 : 5;
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            if (n5 == 0) {
                n7 = (int)rectangle2D.getWidth() + 6 * n8;
                n6 = (int)rectangle2D.getHeight() + 6 * n8;
            } else {
                n6 = (int)rectangle2D.getWidth() + 6 * n8;
                n7 = (int)rectangle2D.getHeight() + 6 * n8;
            }
            BufferedImage bufferedImage = new BufferedImage(n7, n6, 2);
            BufferedImage bufferedImage2 = new BufferedImage(n7, n6, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setFont(font);
            graphics2D.setColor(color2);
            graphics2D.drawString(string, 3 * n8, 3 * n8);
            ConvolveOp convolveOp = new ConvolveOp(n4 == 0 ? kernelThin : kernelFat, 1, null);
            convolveOp.filter(bufferedImage, bufferedImage2);
            graphics.drawImage(bufferedImage2, n - 3 * n8 + n3, n2 - 3 * n8 + n3, null);
        }
        if (color != null) {
            graphics.setFont(font);
            graphics.setColor(color);
            graphics.drawString(string, n, n2);
        }
    }

    static Icon reescala(Icon icon, int n, int n2) {
        if (icon == null) {
            return null;
        }
        if (icon.getIconHeight() == n2 && icon.getIconWidth() == n) {
            return icon;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconHeight(), icon.getIconWidth(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    static int getOpacity() {
        return NimRODUtils.getMenuOpacity();
    }

    static int getMenuOpacity() {
        try {
            NimRODTheme nimRODTheme = (NimRODTheme)NimRODLookAndFeel.theme;
            return nimRODTheme.getMenuOpacity();
        }
        catch (Throwable throwable) {
            return 195;
        }
    }

    static float getMenuOpacityFloat() {
        return (float)NimRODUtils.getMenuOpacity() / 255.0f;
    }

    static int getFrameOpacity() {
        try {
            NimRODTheme nimRODTheme = (NimRODTheme)NimRODLookAndFeel.theme;
            return nimRODTheme.getFrameOpacity();
        }
        catch (Throwable throwable) {
            return 180;
        }
    }

    static float getFrameOpacityFloat() {
        return (float)NimRODUtils.getFrameOpacity() / 255.0f;
    }
}

