/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class NimRODTextAreaUI
extends BasicTextAreaUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiTextML miTextML;

    public NimRODTextAreaUI(JComponent jComponent) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODTextAreaUI(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.miTextML = new MiTextML();
        this.getComponent().addMouseListener(this.miTextML);
        this.getComponent().addFocusListener(this.miTextML);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.miTextML);
        this.getComponent().removeFocusListener(this.miTextML);
    }

    public boolean isFocus() {
        return this.focus;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    protected void paintBackground(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        Border border = jTextComponent.getBorder();
        if (border != null && border instanceof NimRODBorders.NimRODGenBorder) {
            graphics.setColor(this.getComponent().getBackground());
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fillRoundRect(2, 2, jTextComponent.getWidth() - 4, jTextComponent.getHeight() - 4, 7, 7);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            if (jTextComponent.isEnabled() && jTextComponent.isEditable()) {
                if (this.focus) {
                    NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 2, 2, NimRODLookAndFeel.getFocusColor());
                } else if (this.rollover) {
                    NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 2, 2, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            }
        } else {
            super.paintBackground(graphics);
        }
    }

    class MiTextML
    extends MouseAdapter
    implements FocusListener {
        MiTextML() {
        }

        protected void refreshBorder() {
            if (NimRODTextAreaUI.this.getComponent().getParent() != null) {
                JTextComponent jTextComponent = NimRODTextAreaUI.this.getComponent();
                jTextComponent.getParent().repaint(((Component)jTextComponent).getX() - 5, ((Component)jTextComponent).getY() - 5, ((Component)jTextComponent).getWidth() + 10, ((Component)jTextComponent).getHeight() + 10);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            NimRODTextAreaUI.this.rollover = false;
            this.refreshBorder();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODTextAreaUI.this.rollover = true;
            this.refreshBorder();
        }

        public void focusGained(FocusEvent focusEvent) {
            NimRODTextAreaUI.this.focus = true;
            this.refreshBorder();
        }

        public void focusLost(FocusEvent focusEvent) {
            NimRODTextAreaUI.this.focus = false;
            this.refreshBorder();
        }
    }
}

