/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class NimRODComboBoxUI
extends MetalComboBoxUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiML miML;
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODComboBoxUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.comboBox.isOpaque();
        this.comboBox.setOpaque(false);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.comboBox.setOpaque(this.oldOpaque);
    }

    protected void installListeners() {
        super.installListeners();
        this.miML = new MiML();
        this.comboBox.addMouseListener(this.miML);
        this.comboBox.addFocusListener(this.miML);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.miML);
        this.comboBox.removeFocusListener(this.miML);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (this.comboBox.isEditable()) {
            dimension.height = this.editor.getPreferredSize().height - 2;
        }
        dimension.width += 20;
        return dimension;
    }

    protected ComboBoxEditor createEditor() {
        return new NimRODComboBoxEditor();
    }

    protected JButton createArrowButton() {
        return new NimRODComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.buttonDownIcon"), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    public class MiML
    extends MouseAdapter
    implements FocusListener {
        protected void refresh() {
            if (NimRODComboBoxUI.this.comboBox != null && NimRODComboBoxUI.this.comboBox.getParent() != null) {
                NimRODComboBoxUI.this.comboBox.getParent().repaint(NimRODComboBoxUI.this.comboBox.getX() - 5, NimRODComboBoxUI.this.comboBox.getY() - 5, NimRODComboBoxUI.this.comboBox.getWidth() + 10, NimRODComboBoxUI.this.comboBox.getHeight() + 10);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            NimRODComboBoxUI.this.rollover = false;
            this.refresh();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODComboBoxUI.this.rollover = true;
            this.refresh();
        }

        public void focusGained(FocusEvent focusEvent) {
            NimRODComboBoxUI.this.focus = true;
            this.refresh();
        }

        public void focusLost(FocusEvent focusEvent) {
            NimRODComboBoxUI.this.focus = false;
            this.refresh();
        }
    }

    private final class NimRODComboBoxButton
    extends MetalComboBoxButton {
        private static final long serialVersionUID = 1L;

        public NimRODComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
            super(jComboBox, icon, bl, cellRendererPane, jList);
            NimRODComboBoxUI.this.miML = new MiML();
            this.addMouseListener(NimRODComboBoxUI.this.miML);
            this.addFocusListener(NimRODComboBoxUI.this.miML);
        }

        public void paintComponent(Graphics graphics) {
            Object object;
            Object object2;
            boolean bl = false;
            if (this.iconOnly) {
                object2 = NimRODBorders.getComboButtonBorder();
                object = object2.getBorderInsets(this.comboBox);
                if (this.getSize().height < this.comboIcon.getIconHeight() + ((Insets)object).top + ((Insets)object).bottom || this.getSize().width < this.comboIcon.getIconWidth() + ((Insets)object).left + ((Insets)object).right) {
                    bl = true;
                    object2 = NimRODBorders.getThinGenBorder();
                }
                this.setBorder((Border)object2);
                this.setMargin(new Insets(0, 5, 0, 7));
            } else {
                object2 = NimRODBorders.getComboEditorBorder();
                object = object2.getBorderInsets(this.comboBox);
                if (this.getSize().height < this.getFont().getSize() + ((Insets)object).top + ((Insets)object).bottom) {
                    bl = true;
                    object2 = NimRODBorders.getThinGenBorder();
                }
                this.setBorder((Border)object2);
                this.setOpaque(false);
            }
            if (!this.iconOnly && this.comboBox != null) {
                try {
                    graphics.setColor(this.getBackground());
                    if (!bl) {
                        graphics.fillRect(2, 3, this.getWidth() - 4, this.getHeight() - 6);
                    } else {
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    graphics.drawLine(3, 2, this.getWidth() - 4, 2);
                    graphics.drawLine(3, this.getHeight() - 3, this.getWidth() - 4, this.getHeight() - 3);
                    this.paintLeches(graphics);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.iconOnly) {
                object2 = new RoundRectangle2D.Float();
                if (bl) {
                    ((RoundRectangle2D.Float)object2).x = 0.0f;
                    ((RoundRectangle2D.Float)object2).y = 0.0f;
                    ((RoundRectangle2D.Float)object2).width = this.getWidth();
                    ((RoundRectangle2D.Float)object2).height = this.getHeight();
                    ((RoundRectangle2D.Float)object2).arcwidth = 1.0f;
                    ((RoundRectangle2D.Float)object2).archeight = 1.0f;
                } else {
                    ((RoundRectangle2D.Float)object2).x = 2.0f;
                    ((RoundRectangle2D.Float)object2).y = 2.0f;
                    ((RoundRectangle2D.Float)object2).width = this.getWidth() - 4;
                    ((RoundRectangle2D.Float)object2).height = this.getHeight() - 4;
                    ((RoundRectangle2D.Float)object2).arcwidth = 8.0f;
                    ((RoundRectangle2D.Float)object2).archeight = 8.0f;
                }
                this.setOpaque(false);
                this.paintLeches(graphics);
                object = this.getModel();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gradientPaint = null;
                if (object.isPressed() || object.isSelected()) {
                    gradientPaint = new GradientPaint(0.0f, 0.0f, NimRODUtils.getSombra(), 0.0f, this.getHeight(), NimRODUtils.getBrillo());
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fill((Shape)object2);
                } else {
                    gradientPaint = new GradientPaint(0.0f, 0.0f, NimRODUtils.getBrillo(), 0.0f, this.getHeight(), NimRODUtils.getSombra());
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fill((Shape)object2);
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            if (this.isEnabled() && !bl) {
                if (NimRODComboBoxUI.this.focus) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4, 3.0f, NimRODLookAndFeel.getFocusColor());
                } else if (NimRODComboBoxUI.this.rollover) {
                    NimRODUtils.paintFocus(graphics, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4, 3.0f, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintLeches(Graphics graphics) {
            int n;
            Object object;
            boolean bl = this.comboBox.getComponentOrientation().isLeftToRight();
            if (this.ui != null) {
                object = graphics == null ? null : graphics.create();
                try {
                    this.ui.update((Graphics)object, this);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
            object = this.getInsets();
            int n2 = this.getWidth() - (((Insets)object).left + ((Insets)object).right);
            int n3 = this.getHeight() - (((Insets)object).top + ((Insets)object).bottom);
            if (n3 <= 0 || n2 <= 0) {
                return;
            }
            int n4 = ((Insets)object).left;
            int n5 = ((Insets)object).top;
            int n6 = n4 + (n2 - 1);
            int n7 = n5 + (n3 - 1);
            int n8 = 0;
            int n9 = n = bl ? n6 : n4;
            if (this.comboIcon != null) {
                n8 = this.comboIcon.getIconWidth();
                int n10 = this.comboIcon.getIconHeight();
                int n11 = 0;
                if (this.iconOnly) {
                    n = this.getWidth() / 2 - n8 / 2;
                    n11 = this.getHeight() / 2 - n10 / 2;
                } else {
                    n = bl ? n4 + (n2 - 1) - n8 : n4;
                    n11 = n5 + (n7 - n5) / 2 - n10 / 2;
                }
                this.comboIcon.paintIcon(this, graphics, n, n11);
                if (!this.iconOnly) {
                    graphics.setColor(NimRODUtils.getSombra());
                    graphics.drawLine(n - 5, 6, n - 5, this.getHeight() - 6);
                    graphics.setColor(NimRODUtils.getBrillo());
                    graphics.drawLine(n - 4, 6, n - 4, this.getHeight() - 6);
                }
            }
            if (!this.iconOnly && this.comboBox != null) {
                ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
                boolean bl2 = this.getModel().isPressed();
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl2, false);
                component.setFont(this.rendererPane.getFont());
                if (this.model.isArmed() && this.model.isPressed()) {
                    component.setForeground(this.comboBox.getForeground());
                    component.setBackground(this.getBackground());
                } else if (!this.comboBox.isEnabled()) {
                    if (this.isOpaque()) {
                        component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    }
                    component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else {
                    component.setForeground(this.comboBox.getForeground());
                    component.setBackground(this.comboBox.getBackground());
                }
                int n12 = n2 - (((Insets)object).right + n8);
                boolean bl3 = false;
                if (component instanceof JPanel) {
                    bl3 = true;
                }
                if (bl) {
                    this.rendererPane.paintComponent(graphics, component, this, n4, n5, n12, n3, bl3);
                } else {
                    this.rendererPane.paintComponent(graphics, component, this, n4 + n8, n5, n12, n3, bl3);
                }
            }
        }
    }

    public class NimRODComboBoxEditor
    extends MetalComboBoxEditor {
        public NimRODComboBoxEditor() {
            this.editor.setBorder(NimRODBorders.getComboEditorBorder());
        }
    }
}

