/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class NimRODProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new NimRODProgressBarUI();
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        Insets b = this.progressBar.getInsets();
        int largo = this.progressBar.getWidth() - (b.left + b.right);
        int alto = this.progressBar.getHeight() - (b.top + b.bottom);
        int len = this.getAmountFull(b, largo, alto);
        int xi = b.left;
        int yi = b.top;
        int xf = xi + largo;
        int yf = yi + alto;
        int xm = xi + len - 1;
        int ym = yf - len;
        if (this.progressBar.getOrientation() == 0) {
            g2D.setColor(this.progressBar.getForeground());
            g2D.fillRect(xi, yi, xm, yf);
            GradientPaint grad = new GradientPaint(xi, yi, NimRODUtils.brillo, xi, yf, NimRODUtils.sombra);
            g2D.setPaint(grad);
            g2D.fillRect(xi, yi, xm, yf);
            grad = new GradientPaint(xm + 1, yi, NimRODUtils.sombra, xm + 1, yf, NimRODUtils.brillo);
            g2D.setPaint(grad);
            g2D.fillRect(xm + 1, yi, xf, yf);
        } else {
            g2D.setColor(this.progressBar.getForeground());
            g2D.fillRect(xi, ym, xf, yf);
            GradientPaint grad = new GradientPaint(xi, yi, NimRODUtils.sombra, xf, yi, NimRODUtils.brillo);
            g2D.setPaint(grad);
            g2D.fillRect(xi, yi, xf, ym);
            grad = new GradientPaint(xi, ym, NimRODUtils.brillo, xf, ym, NimRODUtils.sombra);
            g2D.setPaint(grad);
            g2D.fillRect(xi, ym, xf, yf);
        }
        this.paintString(g, 0, 0, 0, 0, 0, b);
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        Rectangle rec = new Rectangle();
        rec = this.getBox(rec);
        Insets b = this.progressBar.getInsets();
        int xi = b.left;
        int yi = b.top;
        int xf = c.getWidth() - b.right;
        int yf = c.getHeight() - b.bottom;
        g2D.setColor(this.progressBar.getForeground());
        g2D.fillRect(rec.x, rec.y, rec.width, rec.height);
        if (this.progressBar.getOrientation() == 0) {
            GradientPaint grad = new GradientPaint(rec.x, rec.y, NimRODUtils.brillo, rec.x, rec.height, NimRODUtils.sombra);
            g2D.setPaint(grad);
            g2D.fill(rec);
            grad = new GradientPaint(xi, yi, NimRODUtils.sombra, xi, yf, NimRODUtils.brillo);
            g2D.setPaint(grad);
            g2D.fillRect(xi, yi, rec.x, yf);
            g2D.fillRect(rec.x + rec.width, yi, xf, yf);
        } else {
            GradientPaint grad = new GradientPaint(rec.x, rec.y, NimRODUtils.brillo, rec.width, rec.y, NimRODUtils.sombra);
            g2D.setPaint(grad);
            g2D.fill(rec);
            grad = new GradientPaint(xi, yi, NimRODUtils.sombra, xf, yi, NimRODUtils.brillo);
            g2D.setPaint(grad);
            g2D.fillRect(xi, yi, xf, rec.y);
            g2D.fillRect(xi, rec.y + rec.height, xf, yf);
        }
        this.paintString(g2D, 0, 0, 0, 0, 0, b);
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (!this.progressBar.isStringPainted()) {
            return;
        }
        String text = this.progressBar.getString();
        Point point = this.getStringPlacement(g, text, b.left, b.top, this.progressBar.getWidth() - b.left - b.right, this.progressBar.getHeight() - b.top - b.bottom);
        g.setFont(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0 && !this.progressBar.getComponentOrientation().isLeftToRight()) {
            point.x += this.progressBar.getFontMetrics(g.getFont()).stringWidth(text);
        }
        NimRODUtils.paintShadowTitle(g, text, point.x, point.y, Color.white, Color.black, 1, 1, this.progressBar.getOrientation());
    }
}

