/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class NimRODPopupMenuUI
extends BasicPopupMenuUI {
    private static Robot robot = null;
    private static Kernel kernel = null;
    private BufferedImage fondo = null;
    private BufferedImage blurFondo = null;
    private MiPL mipl;
    private static final int MATRIX = 3;

    public static ComponentUI createUI(JComponent c) {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (kernel == null) {
            float[] elements = new float[9];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = 0.1f;
            }
            int mid = 2;
            elements[mid * mid] = 0.2f;
            kernel = new Kernel(3, 3, elements);
        }
        return new NimRODPopupMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.setBorder(NimRODBorders.getPopupMenuBorder());
        this.popupMenu.setOpaque(false);
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        this.mipl = new MiPL(this.popupMenu);
        this.popupMenu.addPopupMenuListener(this.mipl);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePopupMenuListener(this.mipl);
    }

    public void update(Graphics g, JComponent c) {
        if (this.blurFondo != null) {
            g.drawImage(this.blurFondo, 0, 0, null);
        }
        if (NimRODUtils.getMenuOpacity() > 5) {
            Color cFondo = new Color(c.getBackground().getRed(), c.getBackground().getGreen(), c.getBackground().getBlue(), NimRODUtils.getMenuOpacity());
            g.setColor(cFondo);
            g.fillRect(0, 0, c.getWidth() - 4, c.getHeight() - 4);
        }
    }

    public Popup getPopup(JPopupMenu pop, int x, int y) {
        Dimension dim = pop.getPreferredSize();
        Rectangle rect = new Rectangle(x, y, dim.width, dim.height);
        if (null != robot) {
            this.fondo = robot.createScreenCapture(rect);
            if (NimRODUtils.getMenuOpacity() > 250) {
                this.blurFondo = this.fondo;
            } else {
                Rectangle rectAmp = new Rectangle(x - 3, y - 3, dim.width + 6, dim.height + 6);
                BufferedImage clearFondo = robot.createScreenCapture(rectAmp);
                this.blurFondo = clearFondo.getSubimage(3, 3, dim.width, dim.height);
                BufferedImage tempFondo = clearFondo.getSubimage(0, 0, clearFondo.getWidth(), clearFondo.getHeight());
                ConvolveOp cop = new ConvolveOp(kernel, 1, null);
                cop.filter(clearFondo, tempFondo);
                cop.filter(tempFondo, clearFondo);
                cop.filter(clearFondo, tempFondo);
                Graphics g = this.blurFondo.getGraphics();
                g.drawImage(tempFondo.getSubimage(3, 3, dim.width - 5, dim.height - 5), 0, 0, null);
            }
        }
        return super.getPopup(pop, x, y);
    }

    private class MiPL
    implements PopupMenuListener {
        JPopupMenu papi;

        public MiPL(JPopupMenu pop) {
            this.papi = pop;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
            if (NimRODPopupMenuUI.this.fondo == null) {
                return;
            }
            Graphics g = this.papi.getRootPane().getGraphics();
            Point p = this.papi.getLocationOnScreen();
            Point r = this.papi.getRootPane().getLocationOnScreen();
            g.drawImage(NimRODPopupMenuUI.this.fondo, p.x - r.x, p.y - r.y, null);
            NimRODPopupMenuUI.this.fondo = null;
        }

        public void popupMenuCanceled(PopupMenuEvent ev) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        }
    }
}

