/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODIconFactory;
import com.nilo.plaf.nimrod.NimRODTheme;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.Kernel;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.UIDefaults;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class NimRODLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 7191199335214123414L;
    String fichTheme;
    protected static MetalTheme theme;

    public NimRODLookAndFeel() {
        NimRODTheme nt;
        block10: {
            String opFrame;
            String opMenu;
            String b;
            String w;
            String s3;
            String s2;
            String s1;
            String p3;
            String p2;
            String p1;
            String background;
            String selection;
            this.fichTheme = "";
            nt = new NimRODTheme();
            String nomFich = null;
            try {
                nomFich = System.getProperty("nimrodlf.themeFile");
            }
            catch (Exception ex) {
                // empty catch block
            }
            nomFich = nomFich == null ? "NimRODThemeFile.theme" : nomFich;
            try {
                Properties props = new Properties();
                InputStream res = null;
                try {
                    res = new FileInputStream(nomFich);
                }
                catch (Exception ex) {
                    nomFich = nomFich.equals("NimRODThemeFile.theme") ? "/" + nomFich : nomFich;
                    res = this.getClass().getResourceAsStream(nomFich);
                }
                props.load(res);
                selection = props.getProperty("nimrodlf.selection");
                background = props.getProperty("nimrodlf.background");
                p1 = props.getProperty("nimrodlf.p1");
                p2 = props.getProperty("nimrodlf.p2");
                p3 = props.getProperty("nimrodlf.p3");
                s1 = props.getProperty("nimrodlf.s1");
                s2 = props.getProperty("nimrodlf.s2");
                s3 = props.getProperty("nimrodlf.s3");
                w = props.getProperty("nimrodlf.w");
                b = props.getProperty("nimrodlf.b");
                opMenu = props.getProperty("nimrodlf.menuOpacity");
                opFrame = props.getProperty("nimrodlf.frameOpacity");
                nt = NimRODUtils.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, opMenu, opFrame);
                this.fichTheme = nomFich;
            }
            catch (Exception ex) {
                nt = new NimRODTheme();
            }
            try {
                selection = System.getProperty("nimrodlf.selection");
                background = System.getProperty("nimrodlf.background");
                p1 = System.getProperty("nimrodlf.p1");
                p2 = System.getProperty("nimrodlf.p2");
                p3 = System.getProperty("nimrodlf.p3");
                s1 = System.getProperty("nimrodlf.s1");
                s2 = System.getProperty("nimrodlf.s2");
                s3 = System.getProperty("nimrodlf.s3");
                w = System.getProperty("nimrodlf.w");
                b = System.getProperty("nimrodlf.b");
                opMenu = System.getProperty("nimrodlf.menuOpacity");
                opFrame = System.getProperty("nimrodlf.frameOpacity");
                nt = NimRODUtils.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, opMenu, opFrame);
            }
            catch (Exception ex) {
                if (this.fichTheme.length() != 0) break block10;
                nt = new NimRODTheme();
            }
        }
        NimRODLookAndFeel.setCurrentTheme(nt);
        float[] elements = new float[25];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = 0.1f;
        }
        int mid = 3;
        elements[mid * mid] = 0.2f;
        NimRODUtils.kernelFat = new Kernel(5, 5, elements);
        elements = new float[9];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = 0.1f;
        }
        mid = 2;
        elements[mid * mid] = 0.2f;
        NimRODUtils.kernelThin = new Kernel(3, 3, elements);
    }

    public String getID() {
        return "NimROD";
    }

    public String getName() {
        return "NimROD";
    }

    public String getDescription() {
        return "Look and Feel NimROD, by Nilo J. Gonzalez 2005-2007";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public static void setCurrentTheme(MetalTheme t) {
        MetalLookAndFeel.setCurrentTheme(t);
        theme = t;
        NimRODUtils.rollColor = null;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.put("ButtonUI", "com.nilo.plaf.nimrod.NimRODButtonUI");
        table.put("ToggleButtonUI", "com.nilo.plaf.nimrod.NimRODToggleButtonUI");
        table.put("TextFieldUI", "com.nilo.plaf.nimrod.NimRODTextFieldUI");
        table.put("PasswordFieldUI", "com.nilo.plaf.nimrod.NimRODPasswordFieldUI");
        table.put("CheckBoxUI", "com.nilo.plaf.nimrod.NimRODCheckBoxUI");
        table.put("RadioButtonUI", "com.nilo.plaf.nimrod.NimRODRadioButtonUI");
        table.put("FormattedTextFieldUI", "com.nilo.plaf.nimrod.NimRODFormattedTextFieldUI");
        table.put("SliderUI", "com.nilo.plaf.nimrod.NimRODSliderUI");
        table.put("ListUI", "com.nilo.plaf.nimrod.NimRODListUI");
        table.put("ScrollBarUI", "com.nilo.plaf.nimrod.NimRODScrollBarUI");
        table.put("ToolBarUI", "com.nilo.plaf.nimrod.NimRODToolBarUI");
        table.put("ProgressBarUI", "com.nilo.plaf.nimrod.NimRODProgressBarUI");
        table.put("TabbedPaneUI", "com.nilo.plaf.nimrod.NimRODTabbedPaneUI");
        table.put("TableHeaderUI", "com.nilo.plaf.nimrod.NimRODTableHeaderUI");
        table.put("SplitPaneUI", "com.nilo.plaf.nimrod.NimRODSplitPaneUI");
        table.put("InternalFrameUI", "com.nilo.plaf.nimrod.NimRODInternalFrameUI");
        table.put("DesktopIconUI", "com.nilo.plaf.nimrod.NimRODDesktopIconUI");
        table.put("MenuBarUI", "com.nilo.plaf.nimrod.NimRODMenuBarUI");
        table.put("MenuUI", "com.nilo.plaf.nimrod.NimRODMenuUI");
        table.put("PopupMenuUI", "com.nilo.plaf.nimrod.NimRODPopupMenuUI");
        table.put("PopupMenuSeparatorUI", "com.nilo.plaf.nimrod.NimRODPopupMenuSeparatorUI");
        table.put("MenuItemUI", "com.nilo.plaf.nimrod.NimRODMenuItemUI");
        table.put("CheckBoxMenuItemUI", "com.nilo.plaf.nimrod.NimRODCheckBoxMenuItemUI");
        table.put("RadioButtonMenuItemUI", "com.nilo.plaf.nimrod.NimRODRadioButtonMenuItemUI");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("textInactiveText", NimRODLookAndFeel.getInactiveSystemTextColor().darker());
    }

    private int tercio(int a, int b) {
        return b + 2 * ((a - b) / 3);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        try {
            Color cFore = (Color)table.get("MenuItem.disabledForeground");
            Color cBack = (Color)table.get("MenuItem.foreground");
            Color col = new Color(this.tercio(cFore.getRed(), cBack.getRed()), this.tercio(cFore.getGreen(), cBack.getGreen()), this.tercio(cFore.getBlue(), cBack.getBlue()));
            table.put("MenuItem.disabledForeground", col);
            table.put("Label.disabledForeground", col);
            table.put("CheckBoxMenuItem.disabledForeground", col);
            table.put("Menu.disabledForeground", col);
            table.put("RadioButtonMenuItem.disabledForeground", col);
            table.put("ComboBox.disabledForeground", col);
            table.put("Button.disabledText", col);
            table.put("ToggleButton.disabledText", col);
            table.put("CheckBox.disabledText", col);
            table.put("RadioButton.disabledText", col);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        table.put("MenuBar.border", NimRODBorders.getMenuBarBorder());
        Font fontMenu = ((Font)table.get("Menu.font")).deriveFont(1);
        table.put("MenuItem.acceleratorFont", fontMenu);
        table.put("RadioButtonMenuItem.acceleratorFont", fontMenu);
        table.put("CheckBoxMenuItem.acceleratorFont", fontMenu);
        table.put("BorderPopupMenu.SombraBajIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuBajo.png"));
        table.put("BorderPopupMenu.SombraDerIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuDer.png"));
        table.put("BorderPopupMenu.SombraEsqIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuEsq.png"));
        table.put("BorderPopupMenu.SombraUpIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuUp.png"));
        table.put("BorderPopupMenu.SombraIzqIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuIzq.png"));
        table.put("Tree.collapsedIcon", NimRODIconFactory.getTreeCollapsedIcon());
        table.put("Tree.expandedIcon", NimRODIconFactory.getTreeExpandedIcon());
        table.put("Tree.closedIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirCerrado.png"));
        table.put("Tree.openIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirAbierto.png"));
        table.put("Tree.leafIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/TreeFicheroIcon.png"));
        table.put("Tree.EstructuraCollapsedIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/TreeCollapsedIcon.png"));
        table.put("Tree.EstructuraExpandedIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/TreeExpandedIcon.png"));
        table.put("FileView.directoryIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirCerrado.png"));
        table.put("FileView.fileIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogFicheroIcon.png"));
        table.put("FileView.floppyDriveIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogFloppyIcon.png"));
        table.put("FileView.hardDriveIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogHDIcon.png"));
        table.put("FileChooser.newFolderIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogNewDir.png"));
        table.put("FileChooser.homeFolderIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogHome.png"));
        table.put("FileChooser.upFolderIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirParriba.png"));
        table.put("FileChooser.detailsViewIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogDetails.png"));
        table.put("FileChooser.listViewIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/DialogList.png"));
        table.put("CheckBoxMenuItem.checkIcon", NimRODIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", NimRODIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuItem.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuCheckBox.iconBase", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxBase.png"));
        table.put("MenuCheckBox.iconTick", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxTick.png"));
        table.put("MenuRadioButton.iconBase", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioBase.png"));
        table.put("MenuRadioButton.iconTick", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioTick.png"));
        table.put("CheckBox.iconBase", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxBase.png"));
        table.put("CheckBox.iconTick", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxTick.png"));
        table.put("RadioButton.iconBase", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonBase.png"));
        table.put("RadioButton.iconTick", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonTick.png"));
        table.put("OptionPane.errorIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/Error.png"));
        table.put("OptionPane.informationIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/Inform.png"));
        table.put("OptionPane.warningIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/Warn.png"));
        table.put("OptionPane.questionIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/Question.png"));
        table.put("Slider.horizontalThumbIcon", NimRODIconFactory.getSliderHorizontalIcon());
        table.put("Slider.verticalThumbIcon", NimRODIconFactory.getSliderVerticalIcon());
        table.put("Slider.horizontalThumbIconImage", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalThumbIconImage.png"));
        table.put("Slider.verticalThumbIconImage", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/VerticalThumbIconImage.png"));
        table.put("ScrollBar.horizontalThumbIconImage", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalScrollIconImage.png"));
        table.put("ScrollBar.verticalThumbIconImage", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/VerticalScrollIconImage.png"));
        table.put("Button.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("ToggleButton.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("ScrollPane.border", NimRODBorders.getScrollPaneBorder());
        table.put("Desktop.background", (Color)table.get("MenuItem.background"));
        table.put("InternalFrame.border", NimRODBorders.getInternalFrameBorder());
        table.put("InternalFrame.NimCloseIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameClose.png"));
        table.put("InternalFrame.NimCloseIconRoll", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameCloseRoll.png"));
        table.put("InternalFrame.NimCloseIconPush", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameClosePush.png"));
        table.put("InternalFrame.NimMaxIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMaximiza.png"));
        table.put("InternalFrame.NimMaxIconRoll", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMaximizaRoll.png"));
        table.put("InternalFrame.NimMaxIconPush", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMaximizaPush.png"));
        table.put("InternalFrame.NimMinIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMinimiza.png"));
        table.put("InternalFrame.NimMinIconRoll", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMinimizaRoll.png"));
        table.put("InternalFrame.NimMinIconPush", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameMinimizaPush.png"));
        table.put("InternalFrame.NimResizeIcon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameResize.png"));
        table.put("InternalFrame.NimResizeIconRoll", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameResizeRoll.png"));
        table.put("InternalFrame.NimResizeIconPush", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/FrameResizePush.png"));
        table.put("InternalFrame.closeIcon", NimRODIconFactory.getFrameCloseIcon());
        table.put("InternalFrame.minimizeIcon", NimRODIconFactory.getFrameAltMaximizeIcon());
        table.put("InternalFrame.maximizeIcon", NimRODIconFactory.getFrameMaxIcon());
        table.put("InternalFrame.iconifyIcon", NimRODIconFactory.getFrameMinIcon());
        table.put("InternalFrame.icon", NimRODUtils.loadRes("/com/nilo/plaf/nimrod/icons/Frame.png"));
        table.put("NimRODInternalFrameIconLit.width", new Integer(20));
        table.put("NimRODInternalFrameIconLit.height", new Integer(20));
        Font fontIcon = ((Font)table.get("InternalFrame.titleFont")).deriveFont(1);
        table.put("DesktopIcon.font", fontIcon);
        table.put("NimRODDesktopIcon.width", new Integer(80));
        table.put("NimRODDesktopIcon.height", new Integer(60));
        table.put("NimRODDesktopIconBig.width", new Integer(48));
        table.put("NimRODDesktopIconBig.height", new Integer(48));
        table.put("InternalFrame.activeTitleBackground", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("InternalFrame.activeTitleGradient", NimRODLookAndFeel.getMenuSelectedBackground().darker());
        table.put("InternalFrame.inactiveTitleBackground", NimRODLookAndFeel.getMenuBackground().brighter());
        table.put("InternalFrame.inactiveTitleGradient", NimRODLookAndFeel.getMenuBackground().darker());
    }
}

