/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonUI;

public class NimRODButtonUI
extends MetalButtonUI {
    protected MiML miml;
    private static NimRODButtonUI ui;

    public static ComponentUI createUI(JComponent c) {
        if (ui == null) {
            ui = new NimRODButtonUI();
        }
        return ui;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setBorder(NimRODBorders.getButtonBorder());
    }

    public void unsinstallDefaults(AbstractButton button) {
        super.uninstallDefaults(button);
        button.setBorder(MetalBorders.getButtonBorder());
    }

    public void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.miml = new MiML(b);
        b.addMouseListener(this.miml);
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.miml);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!b.isOpaque()) {
            return;
        }
        if (b.isContentAreaFilled()) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(this.selectColor);
            RoundRectangle2D.Float boton = this.hazBoton(b);
            g2D.fill(boton);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted() || !b.isOpaque()) {
            return;
        }
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        g.setColor(this.getFocusColor());
        g.drawRoundRect(2, 2, b.getWidth() - 6, b.getHeight() - 6, 5, 5);
        g.drawRoundRect(3, 3, b.getWidth() - 6, b.getHeight() - 6, 4, 4);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!c.isOpaque()) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        ButtonModel mod = ((AbstractButton)c).getModel();
        if (c.getParent() instanceof JToolBar && !mod.isRollover()) {
            return;
        }
        RoundRectangle2D.Float boton = this.hazBoton(c);
        GradientPaint grad = null;
        grad = mod.isPressed() || mod.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODUtils.sombra, 0.0f, c.getHeight(), NimRODUtils.brillo) : new GradientPaint(0.0f, 0.0f, NimRODUtils.brillo, 0.0f, c.getHeight(), NimRODUtils.sombra);
        g2D.setPaint(grad);
        g2D.fill(boton);
        if (mod.isRollover()) {
            g2D.setColor(NimRODUtils.getRolloverColor());
            g2D.fill(boton);
        }
    }

    private RoundRectangle2D.Float hazBoton(JComponent c) {
        RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
        boton.x = 0.0f;
        boton.y = 0.0f;
        boton.width = c.getWidth();
        boton.height = c.getHeight();
        boton.arcwidth = 8.0f;
        boton.archeight = 8.0f;
        return boton;
    }

    public class MiML
    extends MouseInputAdapter {
        private AbstractButton papi;

        MiML(AbstractButton b) {
            this.papi = b;
        }

        public void mouseEntered(MouseEvent e) {
            this.papi.getModel().setRollover(true);
            this.papi.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.papi.getModel().setRollover(false);
            this.papi.repaint();
        }
    }
}

