/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;

public class NimRODBorders
extends MetalBorders {
    private static Border butBorder;
    private static Border popupMenuBorder;
    private static Border rolloverButtonBorder;
    private static Border scrollPaneBorder;
    private static Border internalFrameBorder;
    private static Border menuBarBorder;

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new NimRODInternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new NimRODPopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getButtonBorder() {
        if (butBorder == null) {
            butBorder = new BorderUIResource.CompoundBorderUIResource(new NimRODButtonBorder(), new BasicBorders.MarginBorder());
        }
        return butBorder;
    }

    public static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new NimRODRolloverButtonBorder();
        }
        return rolloverButtonBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new NimRODScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    public static Border getMenuBarBorder() {
        if (menuBarBorder == null) {
            menuBarBorder = new NimRODMenuBarBorder();
        }
        return menuBarBorder;
    }

    public static class NimRODMenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 116001977502172752L;
        protected static Insets ins = new Insets(0, 10, 0, 10);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public Insets getBorderInsets(Component c) {
            return ins;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = NimRODMenuBarBorder.ins.top;
            insets.left = NimRODMenuBarBorder.ins.left;
            insets.bottom = NimRODMenuBarBorder.ins.bottom;
            insets.right = NimRODMenuBarBorder.ins.right;
            return insets;
        }
    }

    public static class NimRODInternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -4691959764241705857L;
        private static final int grosor = 4;
        protected static Insets ins = new Insets(0, 4, 9, 9);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource colDer;
            ColorUIResource colIzq;
            GradientPaint grad;
            g.translate(x, y);
            Graphics2D g2D = (Graphics2D)g.create();
            g2D.setComposite(AlphaComposite.getInstance(3, NimRODUtils.getFrameOpacityFloat()));
            if (((JInternalFrame)c).isSelected()) {
                grad = new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getPrimaryControlDarkShadow(), w, 0.0f, NimRODLookAndFeel.getPrimaryControl());
                colIzq = NimRODLookAndFeel.getPrimaryControlDarkShadow();
                colDer = NimRODLookAndFeel.getPrimaryControl();
            } else {
                grad = new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getControl(), w, 0.0f, NimRODLookAndFeel.getControlDarkShadow());
                colIzq = NimRODLookAndFeel.getControl();
                colDer = NimRODLookAndFeel.getControlDarkShadow();
            }
            g2D.setColor(colIzq);
            g2D.fillRect(0, 0, 4, h - NimRODInternalFrameBorder.ins.bottom);
            g2D.setPaint(grad);
            g2D.fillRect(0, h - NimRODInternalFrameBorder.ins.bottom, w - NimRODInternalFrameBorder.ins.right + 4, 4);
            g2D.setColor(colDer);
            g2D.fillRect(w - NimRODInternalFrameBorder.ins.right, 0, 4, h - NimRODInternalFrameBorder.ins.bottom);
            g2D.dispose();
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 5, h - 5);
            Icon icono = UIManager.getIcon("BorderPopupMenu.SombraEsqIcon");
            icono.paintIcon(c, g, w - 5, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraUpIcon");
            icono.paintIcon(c, g, w - 5, 0);
            icono = UIManager.getIcon("BorderPopupMenu.SombraIzqIcon");
            icono.paintIcon(c, g, 0, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraBajIcon");
            for (int xi = 5; xi < w - 5; ++xi) {
                icono.paintIcon(c, g, xi, h - 5);
            }
            icono = UIManager.getIcon("BorderPopupMenu.SombraDerIcon");
            for (int yi = 5; yi < h - 5; ++yi) {
                icono.paintIcon(c, g, w - 5, yi);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return ins;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = NimRODInternalFrameBorder.ins.top;
            newInsets.left = NimRODInternalFrameBorder.ins.left;
            newInsets.bottom = NimRODInternalFrameBorder.ins.bottom;
            newInsets.right = NimRODInternalFrameBorder.ins.right;
            return newInsets;
        }
    }

    public static class NimRODScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -6416636693876853556L;
        private static final Insets insets = new Insets(1, 1, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(NimRODLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }

    public static class NimRODRolloverButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056469L;
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!((AbstractButton)c).isBorderPainted()) {
                return;
            }
            ButtonModel model = ((AbstractButton)c).getModel();
            if (model.isRollover()) {
                g.setColor(NimRODLookAndFeel.getControlDarkShadow());
                g.drawRoundRect(0, 0, w - 1, h - 1, 8, 8);
                RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
                boton.x = 0.0f;
                boton.y = 0.0f;
                boton.width = c.getWidth();
                boton.height = c.getHeight();
                boton.arcwidth = 8.0f;
                boton.archeight = 8.0f;
                GradientPaint grad = null;
                grad = model.isPressed() ? new GradientPaint(0.0f, 0.0f, NimRODUtils.sombra, 0.0f, c.getHeight() / 2, NimRODUtils.brillo) : new GradientPaint(0.0f, 0.0f, NimRODUtils.brillo, 0.0f, c.getHeight(), NimRODUtils.sombra);
                Graphics2D g2D = (Graphics2D)g;
                g2D.setPaint(grad);
                g2D.fill(boton);
            }
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = NimRODRolloverButtonBorder.borderInsets.top;
            newInsets.left = NimRODRolloverButtonBorder.borderInsets.left;
            newInsets.bottom = NimRODRolloverButtonBorder.borderInsets.bottom;
            newInsets.right = NimRODRolloverButtonBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class NimRODPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056468L;
        protected static Insets borderInsets = new Insets(1, 1, 5, 5);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 5, h - 5);
            Icon icono = UIManager.getIcon("BorderPopupMenu.SombraEsqIcon");
            icono.paintIcon(c, g, w - 5, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraUpIcon");
            icono.paintIcon(c, g, w - 5, 0);
            icono = UIManager.getIcon("BorderPopupMenu.SombraIzqIcon");
            icono.paintIcon(c, g, 0, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraBajIcon");
            for (int xi = 5; xi < w - 5; ++xi) {
                icono.paintIcon(c, g, xi, h - 5);
            }
            icono = UIManager.getIcon("BorderPopupMenu.SombraDerIcon");
            for (int yi = 5; yi < h - 5; ++yi) {
                icono.paintIcon(c, g, w - 5, yi);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = NimRODPopupMenuBorder.borderInsets.top;
            newInsets.left = NimRODPopupMenuBorder.borderInsets.left;
            newInsets.bottom = NimRODPopupMenuBorder.borderInsets.bottom;
            newInsets.right = NimRODPopupMenuBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class NimRODButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056467L;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JButton button;
            if (!((AbstractButton)c).isBorderPainted()) {
                return;
            }
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRoundRect(0, 0, w - 1, h - 1, 8, 8);
            if (c instanceof JButton && (button = (JButton)c).isDefaultButton()) {
                g.setColor(NimRODLookAndFeel.getControlDarkShadow().darker());
                g.drawRoundRect(1, 1, w - 3, h - 3, 7, 7);
            }
        }
    }
}

